﻿using System;
using System.Windows.Forms;
using MVShareStore;

namespace MVDataServer 
{
	internal class DataSend 
	{
		internal static bool EnableComs(Main main, ToolStripMenuItem comsEnableMenu) {
			try {
				DataCom.ComsEnabled = !comsEnableMenu.Checked;
				if (DataCom.ComsEnabled)
					comsEnableMenu.Text = "Disable Data Send / Communications";
				else
					comsEnableMenu.Text = "Enable Data Send / Communications";

				return comsEnableMenu.Checked = DataCom.ComsEnabled;
			}
			catch(Exception e) {
				if (main.showNotifications) MessageBox.Show("Error enabling / disabling Data Communications: " + (Data.LastError = e.Message), "Enable Data Communications", MessageBoxButtons.OK, MessageBoxIcon.Error);
				main.setStatusBar("Error enabling / disabling Data Communications: " + (Data.LastError = e.Message));
				return DataCom.ComsEnabled;
			}
		}
		internal static bool SetComsOptions(Main main) {
			try {
				if(!DataCom.ComsEnabled) {
					Data.LastError = "Unable to display / set Data Send / Communications Options - Inter process communcations are not currently enabled";
					return false;
				}

				MVShareStore.forms.ComsOptions ComsOptions = new MVShareStore.forms.ComsOptions();
				ComsOptions.ShowDialog();

				return true;
			}
			catch (Exception e) {
				if (main.showNotifications) MessageBox.Show("Error Setting Data Communications Options: " + (Data.LastError = e.Message), "Set Data Communications Options", MessageBoxButtons.OK, MessageBoxIcon.Error);
				main.setStatusBar("Error setting Data Communications Options: " + (Data.LastError = e.Message));
				return false;
			}
		}

	}
}
