﻿using System;
using System.Windows.Forms;
using MVShareStore;

namespace MVDataServer
{
	public partial class Main : Form
	{
		public Main() {

			//////////////////////////////////////////////////////////////////////
			//
			//		Global and General Routines.
			//
			//////////////////////////////////////////////////////////////////////

			InitializeComponent();

			if(!Data.ReadSettings()) {
				setStatusBar(Data.LastError);
			}

			HelpHideNotificationsMenuItem.Checked = Settings.HideNotifications;
//			HelpAutoCloseSharesMenuItem.Checked = Data.AutoCloseShares;

			setStatusBar("MV Share Store Server Version: " + Properties.Settings.Default.VERSION + ". Library Version: " + Data.Version);
		}

		private void Main_FormClosing(object sender, FormClosingEventArgs e) {
			bool save = true;
			if ((Data.CurrentDataStore != null) && (Data.CurrentDataStore.Dirty)) {
				save = MessageBox.Show("The currently active Data Store " + Data.CurrentDataStore.Name + " has been modified. Do you want to save it to disk before closing the server?", "Close MVShareStore Server", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes;
			}

			if(!Data.SaveSettings()) {
				MessageBox.Show(Data.LastError, "Saving Server Settings", MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
			Data.CloseAll(save);
			ShareStore.CloseShareStore(this);
		}

		internal string setStatusBar(string status) {
			return StatusBar.Items[0].Text = status;
		}

		internal bool showNotifications { get { return !HelpHideNotificationsMenuItem.Checked; } }

		#region File Menu Routines
		//////////////////////////////////////////////////////////////////////
		//
		//		File Menu Routines.
		//
		//////////////////////////////////////////////////////////////////////

		private void FileMenu_DropDownOpening(object sender, EventArgs e) {
			FileOpenConfigFileAsDataStoreMenuItem.Visible = Properties.Settings.Default.ENABLE_MVCONFIG_SUPPORT;
			FileCloseShareStoreMenuItem.Enabled = MVShareStore.ShareStore.isOpen;
			FileOpenShareStoreMenuItem.Enabled = !MVShareStore.ShareStore.isOpen;
			FileSaveDataPackMenuItem.Enabled = FileSaveDataShareMenuItem.Enabled = false;
//			if (Data.CurrentDataStore != null) FileSaveMenuItem.Enabled = true;
			if (Data.CurrentDataPack != null) FileSaveDataPackMenuItem.Enabled = true;
			if (Data.CurrentDataShare != null) FileSaveDataShareMenuItem.Enabled = true;
		}

		private void FileNewMenuItem_Click(object sender, EventArgs e) {	
			DataStore.CreateDataStore(this);
		}

		private void FileNewMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataStore and make it the currently active Data Store");
		}

		private void FileNewDataPackMenuItem_Click(object sender, EventArgs e) {
			DataPack.CreateDataPack(this);
		}

		private void FileNewDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataPack and make it the currently active Data Pack");
		}

		private void FileNewDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.CreateDataShare(this);
		}

		private void FileNewDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataShare and make it the currently active Data Share");
		}

		private void FileNewDataStoreMenuItem_Click(object sender, EventArgs e) {
			DataStore.CreateDataStore(this);
		}

		private void FileNewDataStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataStore and make it the currently active Data Store");
		}

		private void FileOpenMenuItem_Click(object sender, EventArgs e) {
			DataStore.OpenDataStore(this);
		}

		private void FileOpenMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Open a saved DataStore and make it the currently active DataStore from a file on disk");
		}

		private void FileOpenAsDataPackMenuItem_Click(object sender, EventArgs e) {
			DataStore.OpenAsDataPack(this);
		}

		private void FileOpenAsDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Open a saved DataStore as the currently active DataPack from a file on disk");
		}

		private void FileOpenAsDataShareMenuItem_Click(object sender, EventArgs e) {
			DataStore.OpenAsDataShare(this);
		}

		private void FileOpenAsDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Open a saved DataStore as the currently active DataShare from a file on disk");
		}

		private void FileOpenConfigFileAsDataStoreMenuItem_Click(object sender, EventArgs e) {
			DataStore.OpenConfigFile(this);
		}

		private void FileOpenConfigFileAsDataStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Open an MVConfig XML format configuration file and load it as a DataStore");
		}

		private void FileSaveMenuItem_Click(object sender, EventArgs e) {
			DataStore.SaveDataStore(this);
		}

		private void FileSaveMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Save the currently active DataStore to a file on disk (optionally creating a new DataStore first if it does not already exist)");
		}

		private void FileSaveDataPackMenuItem_Click(object sender, EventArgs e) {
			DataStore.SaveDataPack(this);
		}

		private void FileSaveDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Save the currently active DataPack to a file on disk (optionally creating a new DataStore first if it does not already exist)");
		}

		private void FileSaveDataShareMenuItem_Click(object sender, EventArgs e) {
			DataStore.SaveDataShare(this);
		}

		private void FileSaveDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Save the currently active DataShare as a DataStore to a file on disk");
		}

		private void ChangeOwnerMenuItem_Click(object sender, EventArgs e) {
			ShareStore.ChangeOwner(this);
		}

		private void ChangeOwnerMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Change the default Owner / User for this Server");
		}

		private void FileOpenShareStoreMenuItem_Click(object sender, EventArgs e) {
			ShareStore.OpenShareStore(this);
		}

		private void FileOpenShareStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Open a new ShareStore (as long as one is not already open) and optionally specify a different name for it");
		}

		private void FileCloseShareStoreMenuItem_Click(object sender, EventArgs e) {
			ShareStore.CloseShareStore(this);
		}

		private void FileCloseShareStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Close the currently open ShareStore. Number of current users = " + MVShareStore.ShareStore.Users);
		}

		private void FileExitMenuItem_Click(object sender, EventArgs e) {
			bool save = true;
			if((Data.CurrentDataStore != null) && (Data.CurrentDataStore.Dirty)) {
				save = MessageBox.Show("The currently active Data Store " + Data.CurrentDataStore.Name + " has been modified. Do you want to save it to disk before closing the server?", "Close MVShareStore Server", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes;
			}
			Data.CloseAll(save);
			ShareStore.CloseShareStore(this);
			Close();
		}

		private void FileExitMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Close the MV Share Store Server and exit");
		}

		#endregion
		#region Data Menu Routines
		//////////////////////////////////////////////////////////////////////
		//
		//		Data Menu Routines.
		//
		//////////////////////////////////////////////////////////////////////

		private void DataMenu_DropDownOpening(object sender, EventArgs e) {
			DataEditDataPackMenuItem.Enabled = DataListDataPackMenuItem.Enabled = DataSortDataPackMenuItem.Enabled = DataMergeDataPackMenuItem.Enabled = DataExtractDataPackMenuItem.Enabled = DataFindDataItemMenuItem.Enabled = DataEditDataItemMenuItem.Enabled = DataDeleteDataPackMenuItem.Enabled = DataConvertDataPackToShareMenuItem.Enabled = DataConvertDataPackToStoreMenuItem.Enabled = DataSetCodeFieldDescriptionMenuItem.Enabled = false;
			if (Data.CurrentDataPack != null) {
				DataEditDataPackMenuItem.Enabled = DataListDataPackMenuItem.Enabled = DataSortDataPackMenuItem.Enabled = DataMergeDataPackMenuItem.Enabled = DataExtractDataPackMenuItem.Enabled = DataFindDataItemMenuItem.Enabled = DataEditDataItemMenuItem.Enabled = DataDeleteDataPackMenuItem.Enabled = DataConvertDataPackToShareMenuItem.Enabled = DataConvertDataPackToStoreMenuItem.Enabled = DataSetCodeFieldDescriptionMenuItem.Enabled = true;
			}
		}

		private void DataCreateDataPackMenuItem_Click(object sender, EventArgs e) {
			DataPack.CreateDataPack(this);
		}

		private void DataCreateDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataPack and optionally populate it with data items");
		}

		private void DataEditDataPackMenuItem_Click(object sender, EventArgs e) {
			DataPack.EditDataPack(this);
		}

		private void DataEditDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Edit (add, insert, delete) the data items in the currently active Data Pack. Current item count = " + Data.CurrentDataPack.ItemCount);
		}

		private void DataListDataPackMenuItem_Click(object sender, EventArgs e) {
			DataPack.ListDataPack(this);
		}

		private void DataListDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("List the data items in the currently active DataPack. Current item count = " + Data.CurrentDataPack.ItemCount);
		}

		private void DataSortDataPackMenuItem_Click(object sender, EventArgs e) {
			DataPack.SortDataPack(this);
		}

		private void DataSortDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Sort the data items in the currently active DataPack. Current item count = " + Data.CurrentDataPack.ItemCount);
		}

		private void DataMergeDataPackMenuItem_Click(object sender, EventArgs e) {
			DataPack.MergeDataPack(this);
		}

		private void DataMergeDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Merge the data items in the currently active DataPack with another set of Data Items. Current item count = " + Data.CurrentDataPack.ItemCount);
		}

		private void DataExtractDataPackMenuItem_Click_1(object sender, EventArgs e) {
			DataPack.ExtractDataPack(this);
		}

		private void DataExtractDataPackMenuItem_MouseEnter_1(object sender, EventArgs e) {
			setStatusBar("Extract and optionally edit an embedded DataPack from the currently active DataPack, optionally removing it in the process. Current item count = " + Data.CurrentDataPack.ItemCount);
		}

		private void DataFindDataItemMenuItem_Click(object sender, EventArgs e) {
			DataPack.FindDataItem(this);
		}

		private void DataFindDataItemMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Find a particular Data Item in the currently active DataPack using its name or index. Current item count = " + Data.CurrentDataPack.ItemCount);
		}

		private void DataEditDataItemMenuItem_Click(object sender, EventArgs e) {
			DataPack.FindDataItem(this, true);
		}

		private void DataEditDataItemMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Find and edit a particular Data Item in the currently active DataPack using its name or index. Current item count = " + Data.CurrentDataPack.ItemCount);
		}

		private void DataDeleteDataPackMenuItem_Click(object sender, EventArgs e) {
			DataPack.DeleteDataPack(this);
		}

		private void DataDeleteDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Close / delete the currently active DataPack. Current item count = " + Data.CurrentDataPack.ItemCount);
		}

		private void DataConvertDataPackToShareMenuItem_Click(object sender, EventArgs e) {
			DataPack.ConvertDataPackToShare(this);
		}

		private void DataConvertDataPackToShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Convert the currently active DataPack into a DataShare so it can optionally be shared with other applications. Current item count = " + Data.CurrentDataPack.ItemCount);
		}

		private void DataConvertDataPackToStoreMenuItem_Click(object sender, EventArgs e) {
			DataPack.ConvertDataPackToStore(this);
		}

		private void DataConvertDataPackToStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Convert the currently active DataPack into a DataStore so that it can be optionally saved to disk. Current item count = " + Data.CurrentDataPack.ItemCount);
		}

		private void DataSetCodeFieldDescriptionMenuItem_Click(object sender, EventArgs e) {
			DataPack.SetDataPackCodeDescription(this);
		}

		private void DataSetCodeFieldDescriptionMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Set a Header / Description detailing the purpose / use of the Code Field in this DataPack. Current item count = " + Data.CurrentDataPack.ItemCount);
		}

		#endregion
		#region Share Menu Routines
		//////////////////////////////////////////////////////////////////////
		//
		//		Share Menu Routines.
		//
		//////////////////////////////////////////////////////////////////////

		private void ShareMenu_DropDownOpening(object sender, EventArgs e) {
			ShareEditDataShareMenuItem.Enabled = ShareListDataShareMenuItem.Enabled = ShareSortDataShareMenuItem.Enabled = ShareMergeDataShareMenuItem.Enabled = ShareExtractDataPackMenuItem.Enabled = ShareFindDataItemMenuItem.Enabled = ShareEditDataItemMenuItem.Enabled = ShareAddDataHeaderItemsMenuItem.Enabled = ShareListDataHeaderItemsMenuItem.Enabled = ShareCloseDataShareMenuItem.Enabled = ShareConvertDataShareToStoreMenuItem.Enabled = ShareSetCodeFieldDescriptionMenuItem.Enabled = SharePostDataShareMenuItem.Enabled = ShareRepostDataShareMenuItem.Enabled = false;
			ShareCreateUsingDataPackMenuItem.Enabled = ShareCreateUsingDataShareMenuItem.Enabled = ShareCreateUsingDataStoreMenuItem.Enabled = ShareOpenDataShareMenuItem.Enabled = false;
			if (ShareList.Count > 0) ShareOpenDataShareMenuItem.Enabled = true;
			if (Data.CurrentDataPack != null) ShareCreateUsingDataPackMenuItem.Enabled = true;
			if (Data.CurrentDataShare != null) {
				ShareCreateUsingDataShareMenuItem.Enabled = true;
				ShareEditDataShareMenuItem.Enabled = ShareListDataShareMenuItem.Enabled = ShareSortDataShareMenuItem.Enabled = ShareMergeDataShareMenuItem.Enabled = ShareExtractDataPackMenuItem.Enabled = ShareFindDataItemMenuItem.Enabled = ShareEditDataItemMenuItem.Enabled = ShareAddDataHeaderItemsMenuItem.Enabled = ShareListDataHeaderItemsMenuItem.Enabled = ShareCloseDataShareMenuItem.Enabled = ShareConvertDataShareToStoreMenuItem.Enabled = ShareSetCodeFieldDescriptionMenuItem.Enabled = SharePostDataShareMenuItem.Enabled = true;
				if (Data.CurrentDataShare.Posted) ShareRepostDataShareMenuItem.Enabled = true;
			}
			if (Data.CurrentDataStore != null) ShareCreateUsingDataStoreMenuItem.Enabled = true;
		}

		private void ShareCreateDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.CreateDataShare(this);
		}

		private void ShareCreateDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataShare, optionally populating it with data items");
		}

		private void ShareCreateUsingDataPackMenuItem_Click(object sender, EventArgs e) {
			DataShare.CreateDataShare(this, Data.CurrentDataPack);
		}

		private void ShareCreateUsingDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataShare using the currently active Data Pack and optionally editing its data items");
		}

		private void ShareCreateUsingDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.CreateDataShare(this, Data.CurrentDataShare);
		}

		private void ShareCreateUsingDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataShare using the currently active Data Share and optionally editing its data items");
		}

		private void ShareCreateUsingDataStoreMenuItem_Click(object sender, EventArgs e) {
			DataShare.CreateDataShare(this, Data.CurrentDataStore);
		}

		private void ShareCreateUsingDataStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataShare using the currently active Data Store and optionally editing its data items");
		}

		private void ShareOpenDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.OpenDataShare(this);
		}

		private void ShareOpenDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Open an existing DataShare using its ID or Name");
		}

		private void ShareListDataSharesMenuItem_Click(object sender, EventArgs e) {
			DataShare.ListDataShares(this);
		}

		private void ShareListDataSharesMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("List and optionally filter all the available Data Shares");
		}

		private void ShareEditDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.EditDataShare(this);
		}

		private void ShareEditDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Edit (add, insert, delete) the data items in the currently active Data Share. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareListDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.ListDataShare(this);
		}

		private void ShareListDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("List all the data items the currently active DataShare. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareSortDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.SortDataShare(this);
		}

		private void ShareSortDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Sort all the data items the currently active DataShare. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareMergeDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.MergeDataShare(this);
		}

		private void ShareMergeDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Merge the data items in the currently active DataShare with another set of Data Items. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareExtractDataPackMenuItem_Click(object sender, EventArgs e) {
			DataShare.ExtractDataPack(this);
		}

		private void ShareExtractDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Extract and optionally edit an embedded DataPack from the currently active DataShare, optionally removing it in the process. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareFindDataItemMenuItem_Click(object sender, EventArgs e) {
			DataShare.FindDataItem(this);
		}

		private void ShareFindDataItemMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Find a particular Data Item in the currently active DataShare using its name or index. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareEditDataItemMenuItem_Click(object sender, EventArgs e) {
			DataShare.FindDataItem(this, true);
		}

		private void ShareEditDataItemMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Find and edit a particular Data Item in the currently active DataShare using its name or index. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareAddDataHeaderItemsMenuItem_Click(object sender, EventArgs e) {
			DataShare.AddShareHeaderData(this);
		}

		private void ShareAddDataHeaderItemsMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Add new Header / Meta Data Items to the currently active Data Share Header");
		}

		private void ShareListDataHeaderItemsMenuItem_Click(object sender, EventArgs e) {
			DataShare.ListShareHeaderData(this);
		}

		private void ShareListDataHeaderItemsMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("List all the Header / Meta Data Items in the currently active Data Share Header");
		}

		private void ShareCloseDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.CloseDataShare(this);
		}

		private void ShareCloseDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Close	our copy of the currently active DataShare. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareConvertDataShareToStoreMenuItem_Click(object sender, EventArgs e) {
			DataShare.ConvertDataShareToStore(this);
		}

		private void ShareConvertDataShareToStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Convert the currently active DataShare into a DataStore so that it can be optionally saved to disk. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareSetCodeFieldDescriptionMenuItem_Click(object sender, EventArgs e) {
			DataShare.SetDataShareCodeDescription(this);
		}

		private void ShareSetCodeFieldDescriptionMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Set a Header / Description detailing the purpose / use of the Code Field in this DataShare. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void SharePostDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.PostDataShare(this);
		}

		private void SharePostDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Post the currently active Data Share so that it can be accessed by other processes. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareRepostDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.RepostDataShare(this);
		}

		private void ShareRepostDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Repost / Update the currently active Data Share so that the updated version can be accessed by other processes. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		#endregion
		#region Store Menu Routines
		//////////////////////////////////////////////////////////////////////
		//
		//		Store Menu Routines.
		//
		//////////////////////////////////////////////////////////////////////

		private void StoreMenuItem_DropDownOpening(object sender, EventArgs e) {
			StoreEditDataStoreMenuItem.Enabled = StoreListDataStoreMenuItem.Enabled = StoreSortDataStoreMenuItem.Enabled = StoreMergeDataStoreMenuItem.Enabled = StoreExtractDataPackMenuItem.Enabled = StoreFindDataItemMenuItem.Enabled = StoreEditDataItemMenuItem.Enabled = StoreAddDataHeaderItemsMenuItem.Enabled = StoreListDataHeaderItemsMenuItem.Enabled = StoreCloseDataStoreMenuItem.Enabled = StoreDeleteDataStoreMenuItem.Enabled = StoreConvertDataStoreToShareMenuItem.Enabled = StoreSetCodeFieldDescriptionMenuItem.Enabled = false;
			StoreCreateUsingDataPackMenuItem.Enabled = StoreCreateUsingDataShareMenuItem.Enabled = StoreCreateUsingDataStoreMenuItem.Enabled = false;
			if (Data.CurrentDataPack != null) StoreCreateUsingDataPackMenuItem.Enabled = true;
			if (Data.CurrentDataShare != null) StoreCreateUsingDataShareMenuItem.Enabled = true;
			if (Data.CurrentDataStore != null) {
				StoreCreateUsingDataStoreMenuItem.Enabled = true;
				StoreEditDataStoreMenuItem.Enabled = StoreListDataStoreMenuItem.Enabled = StoreSortDataStoreMenuItem.Enabled = StoreMergeDataStoreMenuItem.Enabled = StoreExtractDataPackMenuItem.Enabled = StoreFindDataItemMenuItem.Enabled = StoreEditDataItemMenuItem.Enabled = StoreAddDataHeaderItemsMenuItem.Enabled = StoreListDataHeaderItemsMenuItem.Enabled = StoreCloseDataStoreMenuItem.Enabled = StoreDeleteDataStoreMenuItem.Enabled = StoreConvertDataStoreToShareMenuItem.Enabled = StoreSetCodeFieldDescriptionMenuItem.Enabled = true;
			}
		}

		private void StoreCreateDataStoreMenuItem_Click(object sender, EventArgs e) {
			DataStore.CreateDataStore(this);
		}

		private void StoreCreateNewDataStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataStore, optionally populating it with data items");
		}

		private void StoreCreateUsingDataPackMenuItem_Click(object sender, EventArgs e) {
			DataStore.CreateDataStore(this, Data.CurrentDataPack);
		}

		private void StoreCreateUsingDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataStore using the currently active Data Pack and optionally editing its data items");
		}

		private void StoreCreateUsingDataShareMenuItem_Click(object sender, EventArgs e) {
			DataStore.CreateDataStore(this, Data.CurrentDataShare);
		}

		private void StoreCreateUsingDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataStore using the currently active Data Share and optionally editing its data items");
		}

		private void StoreCreateUsingDataStoreMenuItem_Click(object sender, EventArgs e) {
			DataStore.CreateDataStore(this, Data.CurrentDataStore);
		}

		private void StoreCreateUsingDataStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataStore using the currently active Data Store and optionally editing its data items");
		}

		private void StoreEditDataStoreMenuItem_Click(object sender, EventArgs e) {
			DataStore.EditDataStore(this);
		}

		private void StoreEditDataStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Edit (add, insert, delete) the data items in the currently active Data Store. Current item count = " + Data.CurrentDataStore.ItemCount);
		}

		private void StoreListDataStoreMenuItem_Click(object sender, EventArgs e) {
			DataStore.ListDataStore(this);
		}

		private void StoreListDataStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("List all the data items the currently active DataStore. Current item count = " + Data.CurrentDataStore.ItemCount);
		}

		private void StoreSortDataStoreMenuItem_Click(object sender, EventArgs e) {
			DataStore.SortDataStore(this);
		}

		private void StoreSortDataStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Sort all the data items the currently active DataStore. Current item count = " + Data.CurrentDataStore.ItemCount);
		}

		private void StoreMergeDataStoreMenuItem_Click(object sender, EventArgs e) {
			DataStore.MergeDataStore(this);
		}

		private void StoreMergeDataStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Merge the data items in the currently active DataStore with another set of Data Items. Current item count = " + Data.CurrentDataStore.ItemCount);
		}

		private void StoreExtractDataPackMenuItem_Click(object sender, EventArgs e) {
			DataStore.ExtractDataPack(this);
		}

		private void StoreExtractDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Extract and optionally edit an embedded DataPack from the currently active DataStore, optionally removing it in the process. Current item count = " + Data.CurrentDataStore.ItemCount);
		}

		private void StoreFindDataItemMenuItem_Click(object sender, EventArgs e) {
			DataStore.FindDataItem(this);
		}

		private void StoreFindDataItemMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Find a particular Data Item in the currently active DataStore using its name or index");
		}

		private void StoreEditDataItemMenuItem_Click(object sender, EventArgs e) {
			DataStore.FindDataItem(this, true);
		}

		private void StoreEditDataItemMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Find and edit a particular Data Item in the currently active DataStore using its name or index. Current item count = " + Data.CurrentDataStore.ItemCount);
		}

		private void StoreAddDataHeaderItemsMenuItem_Click(object sender, EventArgs e) {
			DataStore.AddStoreHeaderData(this);
		}

		private void StoreAddDataHeaderItemsMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Add new Header / Meta Data Items to the currently active Data Share Header");
		}

		private void StoreListDataHeaderItemsMenuItem_Click(object sender, EventArgs e) {
			DataStore.ListStoreHeaderData(this);
		}

		private void StoreListDataHeaderItemsMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("List all the Header / Meta Data Items in the currently active Data Share Header");
		}

		private void StoreCloseDataStoreMenuItem_Click(object sender, EventArgs e) {
			DataStore.CloseDataStore(this);
		}

		private void StoreCloseDataStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Close the currently active DataStore. Current item count = " + Data.CurrentDataStore.ItemCount);
		}

		private void StoreDeleteDataStoreMenuItem_Click(object sender, EventArgs e) {
			DataStore.DeleteDataStore(this);
		}

		private void StoreDeleteDataStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Close and delete from disk the currently active DataStore. Current item count = " + Data.CurrentDataStore.ItemCount);
		}

		private void StoreConvertDataStoreToShareMenuItem_Click(object sender, EventArgs e) {
			DataStore.ConvertDataStoreToShare(this);
		}

		private void StoreConvertDataStoreToShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Convert the currently active DataStore into a DataShare so that it can be optionally be shared with other applications. Current item count = " + Data.CurrentDataStore.ItemCount);
		}

		private void StoreSetCodeFieldDescriptionMenuItem_Click(object sender, EventArgs e) {
			DataStore.SetDataStoreCodeDescription(this);
		}

		private void StoreSetCodeFieldDescriptionMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Set a Header / Description detailing the purpose / use of the Code Field in this DataStore. Current item count = " + Data.CurrentDataStore.ItemCount);
		}

		#endregion
		#region Send Menu Routines
		//////////////////////////////////////////////////////////////////////
		//
		//		Send Menu Routines.
		//
		//////////////////////////////////////////////////////////////////////

		private void SendMenuItem_DropDownOpening(object sender, EventArgs e) {
			SendEnableComsMenuItem.Checked = DataCom.ComsEnabled;
			SendSetComsOptionsMenuItem.Enabled = DataCom.ComsEnabled;
		}

		private void SendEnableComsMenuItem_Click(object sender, EventArgs e) {
			DataSend.EnableComs(this, SendEnableComsMenuItem);
		}

		private void SendEnableComsMenuItem_MouseEnter(object sender, EventArgs e) {
			if (DataCom.ComsEnabled)
				setStatusBar("Disable the sending of Data Communications between processes / hosts");
			else
				setStatusBar("Enable the sending of Data Communications between processes / hosts");
		}

		private void SendSetComsOptionsMenuItem_Click(object sender, EventArgs e) {
			DataSend.SetComsOptions(this);
		}

		private void SendSetComsOptionsMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Set all the Data Send / Communications Options such as whether remote hosts are allowed, defining allowed hosts and setting up data channels between processes");
		}

		#endregion
		#region Help Menu Routines
		//////////////////////////////////////////////////////////////////////
		//
		//		Help Menu Routines.
		//
		//////////////////////////////////////////////////////////////////////

		private void HelpMenu_DropDownOpening(object sender, EventArgs e) {
			HelpSetHistoryDepthMenuItem.Visible = HelpViewErrorMessagesMenuItem.Visible = false;
			HelpEnableErrorHistoryMenuItem.Checked = Settings.ErrorHistoryEnabled;
			if(HelpEnableErrorHistoryMenuItem.Checked)
				HelpSetHistoryDepthMenuItem.Visible = HelpViewErrorMessagesMenuItem.Visible = true;
		}

		private void HelpHideNotificationsMenuItem_Click(object sender, EventArgs e) {
			HelpHideNotificationsMenuItem.Checked = !HelpHideNotificationsMenuItem.Checked;
			Settings.HideNotifications = HelpHideNotificationsMenuItem.Checked;
		}

		private void HelpHideNotificationsMenuItem_MouseEnter(object sender, EventArgs e) {
			if(HelpHideNotificationsMenuItem.Checked)
				setStatusBar("Click to allow MessageBox informational notifications to be displayed");
			else
				setStatusBar("Click to stop MessageBox informational notifications from being displayed");
		}

		private void HelpSetDataFormat_Click(object sender, EventArgs e) {
			Help.SetDateFormat(this);
		}

		private void HelpSetDataFormat_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Set or change the Data Format used to display DateStamps by this program. Date Format must be a valid  C# date format string");
		}

		private void HelpEnableErrorHistoryMenuItem_Click(object sender, EventArgs e) {
			Settings.ErrorHistoryEnabled = !Settings.ErrorHistoryEnabled;
			HelpEnableErrorHistoryMenuItem.Checked = Settings.ErrorHistoryEnabled;
			if (Settings.ErrorHistoryEnabled) HelpEnableErrorHistoryMenuItem.Text = "Disable Error Message History";
			else
				HelpEnableErrorHistoryMenuItem.Text = "Enable Error Message History";
		}

		private void HelpEnableErrorHistoryMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Enable or disable keeping a history (of the depth specified in Error History Depth) of the LastError messages thrown");
		}

		private void HelpSetHistoryDepthMenuItem_Click(object sender, EventArgs e) {
			Help.SetErrorHistoryDepth(this);
		}

		private void HelpSetHistoryDepthMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Set how many error messages from Data.LastError to keep before retiring the earliest?");
		}

		private void HelpViewErrorMessagesMenuItem_Click(object sender, EventArgs e) {
			Help.ShowErrorMessages(this);
		}

		private void HelpViewErrorMessagesMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("View the Error Message History. Current error count = " + Data.ErrorCount);
		}

		private void HelpConceptsMenuItem_Click(object sender, EventArgs e) {
			Help.ShowConcepts(this);
		}

		private void HelpConceptsMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("An overview of the concepts behind the MVShareStore Library and some of its design decisions features");
		}

		private void HelpDataTypesMenuItem_Click(object sender, EventArgs e) {
			Help.ShowDataTypes(this);
		}

		private void HelpDataTypesMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("All the Data Types currently supported by the Library");
		}

		private void HelpApiMenuItem_Click(object sender, EventArgs e) {
			Help.ShowApiDetails(this);
		}

		private void HelpApiMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("High level details of the API exposed by the ShareStore Library and how to programme using the Library");
		}

		private void HelpReadmeMenuItem_Click(object sender, EventArgs e) {
			Help.ShowReadme(this);
		}

		private void HelpReadmeMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Show the MVShareStore Readme file");
		}

		private void HelpAboutMenuItem_Click(object sender, EventArgs e) {
			Help.ShowHelpAbout(this);
		}

		private void HelpAboutMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Show general information regarding this Server program");
		}

		#endregion

		private void MainMenu_MouseLeave(object sender, EventArgs e) {
			setStatusBar("MV Share Store Server Version: " + Properties.Settings.Default.VERSION + ". Library Version: " + Data.Version);
		}
	}
}
