﻿using System;
using Microsoft.VisualBasic;
using System.Windows.Forms;
using MVShareStore;

namespace MVDataClient
{
	/// <summary>
	/// Handle all the Share Store related functions: Open, Close etc.
	/// </summary>
	class ShareStore
	{
		/// <summary>
		/// Open the default ShareStore or of a different name is specified then open one of that name
		/// </summary>
		/// <param name="main">The application Main form</param>
		/// <returns>True if ShareStore successfully opened, otherwise false</returns>
		internal static bool OpenShareStore(Main main) {
			int namelen = MVShareStore.DataShare.MaxNameLength;
			int ownerlen = MVShareStore.DataShare.MaxOwnerLength;

			try {
				string name = Interaction.InputBox("Accept the default / current ShareStore name or specify a different name for this ShareStore", "Get ShareStore Name", MVShareStore.ShareStore.Name);
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar("ShareStore open aborted");		
					return false;
				}
/*
				if (MessageBox.Show(main.setStatusBar("Do you want to change the default DataShare Name and Owner fields maximum lengths?"), "Change Data Share Field Lengths", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes) {
					string numval = Interaction.InputBox("Enter the maximum length allowed for Data Share Names", "Set DataShare Name length", MVShareStore.DataShare.MaxNameLength.ToString());
					int.TryParse(numval, out namelen);
					numval = Interaction.InputBox("Enter the maximum length allowed for Data Share Owners", "Set DataShare Owner length", MVShareStore.DataShare.MaxOwnerLength.ToString());
					int.TryParse(numval, out ownerlen);
				}
*/
				if (MVShareStore.Data.OpenShareStore(name)) {
					if (main.showNotifications) MessageBox.Show("Successfully opened ShareStore " + MVShareStore.ShareStore.Name + ". Data Share Name field Length = " + MVShareStore.DataShare.MaxNameLength + " Owner field length = " + MVShareStore.DataShare.MaxOwnerLength + ". Capacity = " + MVShareStore.ShareList.Capacity, "Open ShareStore", MessageBoxButtons.OK, MessageBoxIcon.Information);
					main.setStatusBar("Successfully opened ShareStore " + MVShareStore.ShareStore.Name + ". Data Share Name field Length = " + MVShareStore.DataShare.MaxNameLength + " Owner field length = " + MVShareStore.DataShare.MaxOwnerLength + ". Capacity = " + MVShareStore.ShareList.Capacity);
					return true;
				}
				else {
					MessageBox.Show(main.setStatusBar("Error opening ShareStore: " + MVShareStore.ShareStore.LastError), "Open ShareStore", MessageBoxButtons.OK, MessageBoxIcon.Error);
					return false;
				}
			}
			catch(Exception e) {
				MessageBox.Show(main.setStatusBar("Error opening ShareStore: " + e.Message), "Open ShareStore", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return false;
			}
		}

		/// <summary>
		/// Close the currently open ShareStore
		/// </summary>
		/// <param name="main">The application Main form</param>
		internal static void CloseShareStore(Main main) {
			MVShareStore.Data.CloseShareStore();
			main.setStatusBar("ShareStore " + MVShareStore.ShareStore.Name + " was closed successfully");
		}

		/// <summary>
		/// Change the Owner / User that is allowed to open private Data Shares
		/// </summary>
		/// <param name="main">The application Main form</param>
		internal static void ChangeOwner(Main main) {
			string owner = Interaction.InputBox("Enter the name of the Owner / User / Group that defines the private DataShares you are allowed to open", "Change Owner / User", Data.CurrentOwnerUser);
			if(!string.IsNullOrEmpty(owner)) {
				Data.CurrentOwnerUser = owner;
				if (main.showNotifications) MessageBox.Show("Successully changed Client Owner / User / Group to " + Data.CurrentOwnerUser, "Change Owner / User", MessageBoxButtons.OK, MessageBoxIcon.Information);
				main.setStatusBar("Successully changed Client Owner / User / Group to " + Data.CurrentOwnerUser);
			}
		}
	}
}
