﻿using System;
using System.Windows.Forms;
using MVShareStore;

namespace MVDataClient
{
	public partial class Main : Form
	{
		public Main() {

			//////////////////////////////////////////////////////////////////////
			//
			//		Global and General Routines.
			//
			//////////////////////////////////////////////////////////////////////

			InitializeComponent();

			if (!Data.ReadSettings()) {
				setStatusBar(Data.LastError);
			}

			HelpHideNotificationsMenuItem.Checked = Properties.Settings.Default.HIDE_NOTIFICATIONS;
//			HelpAutoCloseSharesMenuItem.Checked = Data.AutoCloseShares;

			setStatusBar("MV Share Store Client Version: " + Properties.Settings.Default.VERSION + ". Library Version: " + Data.Version);
		}

		private void Main_FormClosing(object sender, FormClosingEventArgs e) {
			bool save = true;
			if ((Data.CurrentDataStore != null) && (Data.CurrentDataStore.Dirty)) {
				save = MessageBox.Show("The currently active Data Store " + Data.CurrentDataStore.Name + " has been modified. Do you want to save it to disk before closing the client?", "Close MVShareStore Client", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes;
			}

			if (!Data.SaveSettings()) {
				MessageBox.Show(Data.LastError, "Saving Client Settings", MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
			Data.CloseAll(save);
			ShareStore.CloseShareStore(this);
		}

		internal string setStatusBar(string status) {
			return StatusBar.Items[0].Text = status;
		}

		internal bool showNotifications { get { return !HelpHideNotificationsMenuItem.Checked; } }

		#region File Menu Routines
		//////////////////////////////////////////////////////////////////////
		//
		//		File Menu Routines.
		//
		//////////////////////////////////////////////////////////////////////

		private void FileMenu_DropDownOpening(object sender, EventArgs e) {
			FileCloseShareStoreMenuItem.Enabled = MVShareStore.ShareStore.isOpen;
			FileOpenShareStoreMenuItem.Enabled = !MVShareStore.ShareStore.isOpen;
			if (Data.CurrentDataShare != null) FileSaveDataShareMenuItem.Enabled = true;
		}

		private void FileNewMenuItem_Click(object sender, EventArgs e) {
			DataStore.CreateDataStore(this);
		}

		private void FileNewMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataStore and make it the currently active Data Store");
		}

		private void FileNewDataPackMenuItem_Click(object sender, EventArgs e) {
			DataPack.CreateDataPack(this);
		}

		private void FileNewDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataPack and make it the currently active Data Pack");
		}

		private void FileNewDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.CreateDataShare(this);
		}

		private void FileNewDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataShare and make it the currently active Data Share");
		}

		private void FileNewDataStoreMenuItem_Click(object sender, EventArgs e) {
			DataStore.CreateDataStore(this);
		}

		private void FileNewDataStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataStore and make it the currently active Data Store");
		}
/*
		private void FileOpenMenuItem_Click(object sender, EventArgs e) {
			DataStore.OpenDataStore(this);
		}

		private void FileOpenMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Open a saved DataStore and make it the currently active DataStore from a file on disk");
		}

		private void FileOpenAsDataPackMenuItem_Click(object sender, EventArgs e) {
			DataStore.OpenAsDataPack(this);
		}

		private void FileOpenAsDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Open a saved DataStore as the currently active DataPack from a file on disk");
		}
*/
		private void FileOpenAsDataShareMenuItem_Click(object sender, EventArgs e) {
			DataStore.OpenAsDataShare(this);
		}

		private void FileOpenAsDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Open a saved DataStore as the currently active DataShare from a file on disk");
		}
/*
		private void FileSaveMenuItem_Click(object sender, EventArgs e) {
			DataStore.SaveDataStore(this);
		}

		private void FileSaveMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Save the currently active DataStore to a file on disk (optionally creating a new DataStore first if it does not already exist)");
		}

		private void FileSaveDataPackMenuItem_Click(object sender, EventArgs e) {
			DataStore.SaveDataPack(this);
		}

		private void FileSaveDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Save the currently active DataPack to a file on disk (optionally creating a new DataStore first if it does not already exist)");
		}
*/
		private void FileSaveDataShareMenuItem_Click(object sender, EventArgs e) {
			DataStore.SaveDataShare(this);
		}

		private void FileSaveDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Save the currently active DataShare as a DataStore to a file on disk");
		}

		private void ChangeOwnerMenuItem_Click(object sender, EventArgs e) {
			ShareStore.ChangeOwner(this);
		}

		private void ChangeOwnerMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Change the Owner / User for this Client that is allowed to open private Data Shares");
		}

		private void FileOpenShareStoreMenuItem_Click(object sender, EventArgs e) {
			ShareStore.OpenShareStore(this);
		}

		private void FileOpenShareStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Open the ShareStore and optionally specify a different name for it");
		}

		private void FileCloseShareStoreMenuItem_Click(object sender, EventArgs e) {
			ShareStore.CloseShareStore(this);
		}

		private void FileCloseShareStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Close the currently open ShareStore. Number of current users = " + MVShareStore.ShareStore.Users);
		}

		private void FileExitMenuItem_Click(object sender, EventArgs e) {
			Close();
		}

		#endregion
		#region Share Menu Routines
		//////////////////////////////////////////////////////////////////////
		//
		//		Share Menu Routines.
		//
		//////////////////////////////////////////////////////////////////////

		private void ShareMenu_DropDownOpening(object sender, EventArgs e) {
			ShareEditDataShareMenuItem.Enabled = ShareListDataShareMenuItem.Enabled = ShareSortDataShareMenuItem.Enabled = ShareExtractDataPackMenuItem.Enabled = ShareFindDataItemMenuItem.Enabled = ShareEditDataItemMenuItem.Enabled = ShareAddDataHeaderItemsMenuItem.Enabled = ShareListDataHeaderItemsMenuItem.Enabled = ShareCloseDataShareMenuItem.Enabled = ShareConvertDataShareToStoreMenuItem.Enabled = ShareSetCodeFieldDescriptionMenuItem.Enabled = SharePostDataShareMenuItem.Enabled = ShareUpdateDataShareMenuItem.Enabled = false;
			ShareCreateUsingDataShareMenuItem.Enabled = ShareOpenDataShareMenuItem.Enabled = false;
			if (ShareList.Count > 0) ShareOpenDataShareMenuItem.Enabled = true;
			if (Data.CurrentDataShare != null) {
				ShareCreateUsingDataShareMenuItem.Enabled = true;
				ShareEditDataShareMenuItem.Enabled = ShareListDataShareMenuItem.Enabled = ShareSortDataShareMenuItem.Enabled = ShareExtractDataPackMenuItem.Enabled = ShareFindDataItemMenuItem.Enabled = ShareEditDataItemMenuItem.Enabled = ShareAddDataHeaderItemsMenuItem.Enabled = ShareListDataHeaderItemsMenuItem.Enabled = ShareCloseDataShareMenuItem.Enabled = ShareConvertDataShareToStoreMenuItem.Enabled = ShareSetCodeFieldDescriptionMenuItem.Enabled = SharePostDataShareMenuItem.Enabled = true;
				if ((Data.CurrentDataShare.Posted) && (Data.CurrentDataShare.Dirty)) ShareUpdateDataShareMenuItem.Enabled = true;
			}
		}

		private void ShareCreateDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.CreateDataShare(this);
		}

		private void ShareCreateDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataShare, optionally populating it with data items");
		}
/*
		private void ShareCreateUsingDataPackMenuItem_Click(object sender, EventArgs e) {
			DataShare.CreateDataShare(this, Data.CurrentDataPack);
		}

		private void ShareCreateUsingDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataShare using the currently active Data Pack and optionally editing its data items");
		}
*/
		private void ShareCreateUsingDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.CreateDataShare(this, Data.CurrentDataShare);
		}

		private void ShareCreateUsingDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataShare using the currently active Data Share and optionally editing its data items");
		}
/*
		private void ShareCreateUsingDataStoreMenuItem_Click(object sender, EventArgs e) {
			DataShare.CreateDataShare(this, Data.CurrentDataStore);
		}

		private void ShareCreateUsingDataStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Create a new DataShare using the currently active Data Store and optionally editing its data items");
		}
*/
		private void ShareOpenDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.OpenDataShare(this);
		}

		private void ShareOpenDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Open an existing DataShare using its ID or Name");
		}

		private void ShareListDataSharesMenuItem_Click(object sender, EventArgs e) {
			DataShare.ListDataShares(this);
		}

		private void ShareListDataSharesMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("List and optionally filter all the available Data Shares");
		}

		private void ShareEditDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.EditDataShare(this);
		}

		private void ShareEditDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Edit (add, insert, delete) the data items in the currently active Data Share. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareListDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.ListDataShare(this);
		}

		private void ShareListDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("List all the data items the currently active DataShare. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareSortDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.SortDataShare(this);
		}

		private void ShareSortDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Sort all the data items the currently active DataShare. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareExtractDataPackMenuItem_Click(object sender, EventArgs e) {
			DataShare.ExtractDataPack(this);
		}

		private void ShareExtractDataPackMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Extract and optionally edit an embedded DataPack from the currently active DataShare, optionally removing it in the process. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareFindDataItemMenuItem_Click(object sender, EventArgs e) {
			DataShare.FindDataItem(this);
		}

		private void ShareFindDataItemMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Find a particular Data Item in the currently active DataShare using its name or index. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareEditDataItemMenuItem_Click(object sender, EventArgs e) {
			DataShare.FindDataItem(this, true);
		}

		private void ShareEditDataItemMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Find and edit a particular Data Item in the currently active DataShare using its name or index. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareAddDataHeaderItemsMenuItem_Click(object sender, EventArgs e) {
			DataShare.AddShareHeaderData(this);
		}

		private void ShareAddDataHeaderItemsMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Add new Data Items to the currently active Data Share Header area");
		}

		private void ShareListDataHeaderItemsMenuItem_Click(object sender, EventArgs e) {
			DataShare.ListShareHeaderData(this);
		}

		private void ShareListDataHeaderItemsMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("List all the Data Items in the currently active Data Share Header area");
		}

		private void ShareCloseDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.CloseDataShare(this);
		}

		private void ShareCloseDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Close	our copy of the currently active DataShare. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareConvertDataShareToStoreMenuItem_Click(object sender, EventArgs e) {
			DataShare.ConvertDataShareToStore(this);
		}

		private void ShareSetCodeFieldDescriptionMenuItem_Click(object sender, EventArgs e) {
			DataShare.SetDataShareCodeDescription(this);
		}

		private void ShareSetCodeFieldDescriptionMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Set a Header / Description detailing the purpose / use of the Code Field in this DataShare. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void SharePostDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.PostDataShare(this);
		}

		private void SharePostDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Post the currently active Data Share so that it can be accessed by other processes. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareConvertDataShareToStoreMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Convert the currently active DataShare into a DataStore so that it can be optionally saved to disk. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		private void ShareUpdateDataShareMenuItem_Click(object sender, EventArgs e) {
			DataShare.UpdateDataShare(this);
		}

		private void ShareUpdateDataShareMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Update the contents of the currently active Data Share so that the changes can be accessed by other processes. Current item count = " + Data.CurrentDataShare.ItemCount);
		}

		#endregion
		#region Help Menu Routines
		//////////////////////////////////////////////////////////////////////
		//
		//		Help Menu Routines.
		//
		//////////////////////////////////////////////////////////////////////

		private void HelpMenu_DropDownOpening(object sender, EventArgs e) {
			HelpSetHistoryDepthMenuItem.Visible = HelpViewErrorMessagesMenuItem.Visible = false;
			HelpEnableErrorHistoryMenuItem.Checked = Settings.ErrorHistoryEnabled;
			if (HelpEnableErrorHistoryMenuItem.Checked)
				HelpSetHistoryDepthMenuItem.Visible = HelpViewErrorMessagesMenuItem.Visible = true;
		}

		private void HelpHideNotificationsMenuItem_Click(object sender, EventArgs e) {
			HelpHideNotificationsMenuItem.Checked = !HelpHideNotificationsMenuItem.Checked;
		}

		private void HelpHideNotificationsMenuItem_MouseEnter(object sender, EventArgs e) {
			if (HelpHideNotificationsMenuItem.Checked)
				setStatusBar("Click to allow MessageBox informational notifications to be displayed");
			else
				setStatusBar("Click to stop MessageBox informational notifications from being displayed");
		}

		private void HelpSetDataFormat_Click(object sender, EventArgs e) {
			Help.SetDateFormat(this);
		}

		private void HelpSetDataFormat_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Set or change the Data Format used to display DateStamps by this program. Date Format must be a valid  C# date format string");
		}

		private void HelpEnableErrorHistoryMenuItem_Click(object sender, EventArgs e) {
			Settings.ErrorHistoryEnabled = !Settings.ErrorHistoryEnabled;
			HelpEnableErrorHistoryMenuItem.Checked = Settings.ErrorHistoryEnabled;
			if (Settings.ErrorHistoryEnabled) HelpEnableErrorHistoryMenuItem.Text = "Disable Error Message History";
			else
				HelpEnableErrorHistoryMenuItem.Text = "Enable Error Message History";
		}

		private void HelpEnableErrorHistoryMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Enable or disable keeping a history (of the depth specified in Error History Depth) of the LastError messages thrown");
		}

		private void HelpSetHistoryDepthMenuItem_Click(object sender, EventArgs e) {
			Help.SetErrorHistoryDepth(this);
		}

		private void HelpSetHistoryDepthMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Set how many error messages from Data.LastError to keep before retiring the earliest?");
		}

		private void HelpViewErrorMessagesMenuItem_Click(object sender, EventArgs e) {
			Help.ShowErrorMessages(this);
		}

		private void HelpViewErrorMessagesMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("View the Error Message History. Current error count = " + Data.ErrorCount);
		}

		private void HelpConceptsMenuItem_Click(object sender, EventArgs e) {
			Help.ShowConcepts(this);
		}

		private void HelpConceptsMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("An overview of the concepts behind the MVShareStore Library and some of its design decisions features");
		}

		private void HelpDataTypesMenuItem_Click(object sender, EventArgs e) {
			Help.ShowDataTypes(this);
		}

		private void HelpDataTypesMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("All the Data Types currently supported by the Library");
		}

		private void HelpApiMenuItem_Click(object sender, EventArgs e) {
			Help.ShowApiDetails(this);
		}

		private void HelpApiMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("High level details of the API exposed by the ShareStore Library and how to programme using the Library");
		}

		private void HelpReadmeMenuItem_Click(object sender, EventArgs e) {
			Help.ShowReadme(this);
		}

		private void HelpReadmeMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Show the MVShareStore Readme file");
		}

		private void HelpAboutMenuItem_Click(object sender, EventArgs e) {
			Help.ShowHelpAbout(this);
		}

		private void HelpAboutMenuItem_MouseEnter(object sender, EventArgs e) {
			setStatusBar("Show general information regarding this Client program");
		}

		#endregion
		private void MainMenu_MouseLeave(object sender, EventArgs e) {
			setStatusBar("MV Share Store Client Version: " + Properties.Settings.Default.VERSION + ". Library Version: " + Data.Version);
		}
	}
}
