﻿using System;
using System.IO;
using Microsoft.VisualBasic;
using MVShareStore;
using MVConfig;

namespace MVConfigHandler {

	internal class OldConfigFiles {

		private static readonly string DEF_APPNAME = "MVConfig";

		internal static bool CreateOldConfigFile(Main main) {
			try {
				if (string.IsNullOrEmpty(_path)) {
					_path = Interaction.InputBox("Enter the path / directory you want to use for old format Config files", "Config File Path", Properties.Settings.Default.DEFAULT_PATH);
					main.setStatusBar("Default path for Config Files set to: " + _path);
					if (!Directory.Exists(_path)) Directory.CreateDirectory(_path);
				}

				string filename = Interaction.InputBox("Enter the name of the (old format) Config file you want to create", "Enter New Old format Config File Name");
				if (string.IsNullOrEmpty(filename)) {
					main.setStatusBar(Data.LastError = "Error: A name is required to create an new old format Config File");
					return false;
				}

				filename = _path + Path.DirectorySeparatorChar + Path.ChangeExtension(filename, MVShareStore.MVConfigFile.CONFIG_EXT);
				if (!File.Exists(filename)) {
					_config = new MVConfig.MVConfigFile();
					_config.newFile(filename, DEF_APPNAME);
				}
				else {
					_config = new MVConfig.MVConfigFile(filename, DEF_APPNAME);
				}

				_config = new MVConfig.MVConfigFile(filename);
				if (_config == null) {
					main.setStatusBar("Unable to create new old format Config file: " + Data.LastError);
					return false;
				}

				main.setStatusBar("Successfully created new old format Config File " + _config.getFilename());
				return true;
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception creating new old format Config File: " + e.Message);
				return false;
			}
		}

		internal static bool OpenOldConfigFile(Main main) {
			try {
				if (string.IsNullOrEmpty(_path)) {
					_path = Interaction.InputBox("Enter the path / directory you want to use for old format Config files", "Config File Path", Properties.Settings.Default.DEFAULT_PATH);
					main.setStatusBar("Default path for Config Files set to: " + _path);
					if (!Directory.Exists(_path)) Directory.CreateDirectory(_path);
				}

				string filename = Interaction.InputBox("Enter the name of the (old format) Config file you want to open or null to select a file", "Open old format Config File");
				if (string.IsNullOrEmpty(filename)) {
					filename = MVShareStore.ConfigData.SelectFile();
				}
				else {
					filename = _path + Path.DirectorySeparatorChar + Path.ChangeExtension(filename, MVShareStore.MVConfigFile.CONFIG_EXT);
				}
				if (string.IsNullOrEmpty(filename)) {
					main.setStatusBar(Data.LastError = "Error: A name is required to open an old format Config File");
					return false;
				}
				/*
								if (!File.Exists(filename)) {
									main.setStatusBar(Data.LastError = "Error: " + filename + " is not a valid file");
									return false;
								}
				*/
				if (_config == null) {
					_config = new MVConfig.MVConfigFile();
				}
				if (!_config.openFile(filename, DEF_APPNAME)) {
					main.setStatusBar("Unable to open old format Config file " + filename + ": " + Data.LastError);
					return false;
				}

				main.setStatusBar("Successfully opened old format Config File " + _config.getFilename());
				return true;
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception opening old format Config File: " + e.Message);
				return false;
			}
		}

		internal static bool SaveOldConfigFile(Main main) {
			try {

				if (_config == null) {
					main.setStatusBar("Unable to save old format Config file. No Config File open");
					return false;
				}

				if (!_config.saveFile()) {
					main.setStatusBar("Unable to save old format Config file " + _config.getFilename() + ": " + Data.LastError);
					return false;
				}

				main.setStatusBar("Successfully saved old format Config File " + _config.getFilename());
				return true;
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception saving old format Config File: " + e.Message);
				return false;
			}
		}

		internal static bool SaveOldConfigFileAs(Main main) {
			try {
				if (string.IsNullOrEmpty(_path)) {
					_path = Interaction.InputBox("Enter the path / directory you want to use for saving the old format Config files", "Config File Path", Properties.Settings.Default.DEFAULT_PATH);
					main.setStatusBar("Default path for Config Files set to: " + _path);
					if (!Directory.Exists(_path)) Directory.CreateDirectory(_path);
				}

				string filename = Interaction.InputBox("Enter the name of the (old format) Config file you want to save as", "Save old format Config File As");
				if (string.IsNullOrEmpty(filename)) {
					main.setStatusBar(Data.LastError = "Error: A name is required to save the old format Config File");
					return false;
				}

				if (_config == null) {
					main.setStatusBar("Unable to save old format Config file. No Config File currently open");
					return false;
				}

				filename = _path + Path.DirectorySeparatorChar + Path.ChangeExtension(filename, ConfigData.CONFIG_EXT);
				if (!_config.saveFileAs(filename, DEF_APPNAME)) {
					main.setStatusBar("Unable to save old format Config file as " + filename + ": " + Data.LastError);
					return false;
				}

				main.setStatusBar("Successfully saved old format Config File as " + _config.getFilename());
				return true;
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception saving old format Config File: " + e.Message);
				return false;
			}
		}

		internal static bool ViewOldConfigFile(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to view old format Config file. No Config File currently open");
					return false;
				}

				forms.ViewOldConfigFile viewConfigFile = new forms.ViewOldConfigFile(_config);
				viewConfigFile.Show();
				main.setStatusBar("Viewing " + _config.getFilename() + " contents");
				return true;
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception viewing old format Config File: " + e.Message);
				return false;
			}
		}

		public static MVConfig.MVConfigFile ConfigFile { get { return _config; } set { _config = value; } }

		private static MVConfig.MVConfigFile _config = null;
		private static string _path = null;
	}
}
