﻿using System;
using System.IO;
using Microsoft.VisualBasic;
using MVShareStore;

namespace MVConfigHandler {

	internal class NewConfigFiles {

		internal static bool CreateNewConfigFile(Main main) {
			try {
				if (string.IsNullOrEmpty(_path)) {
					_path = Interaction.InputBox("Enter the path / directory you want to use for old format Config files", "Config File Path", Properties.Settings.Default.DEFAULT_PATH);
					main.setStatusBar("Default path for Config Files set to: " + _path);
					if(!Directory.Exists(_path)) Directory.CreateDirectory(_path);
				}

				string filename = Interaction.InputBox("Enter the name of the (new format) Config file you want to create", "Enter New Format Config File Name");
				if (string.IsNullOrEmpty(filename)) {
					main.setStatusBar(Data.LastError = "A name is required to create a new format Config File");
					return false;
				}

				filename = _path + Path.DirectorySeparatorChar + Path.ChangeExtension(filename, ConfigData.CONFIG_EXT);
				if (!File.Exists(filename)) {
					_config = new MVConfigFile();
					_config.newFile(filename);
				}
				else {
					_config = new MVConfigFile(filename);
				}

				if(_config == null) {
					main.setStatusBar("Unable to create new format Config file: " + Data.LastError);
					return false;
				}

				main.setStatusBar("Successfully created new format Config File " + _config.getFilename());
				return true;
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception creating new format Config File: " + e.Message);
				return false; 
			}
		}

		internal static bool OpenNewConfigFile(Main main) {
			try {
				if (string.IsNullOrEmpty(_path)) {
					_path = Interaction.InputBox("Enter the path / directory you want to use for new format Config files", "Config File Path", Properties.Settings.Default.DEFAULT_PATH);
					main.setStatusBar("Default path for Config Files set to: " + _path);
					if (!Directory.Exists(_path)) Directory.CreateDirectory(_path);
				}

				string filename = Interaction.InputBox("Enter the name of the (new format) Config file you want to open or null to select a file", "Open new format Config File");
				if (string.IsNullOrEmpty(filename)) {
					filename = ConfigData.SelectFile();
				}
				else {
					filename = _path + Path.DirectorySeparatorChar + Path.ChangeExtension(filename, ConfigData.CONFIG_EXT);
				}
				if (string.IsNullOrEmpty(filename)) {
					main.setStatusBar(Data.LastError = "Error: A name is required to open a new format Config File");
					return false;
				}
/*
				if (!File.Exists(filename)) {
					main.setStatusBar(Data.LastError = "Error: " + filename + " is not a valid file");
					return false;
				}
*/
				if (_config == null) {
					_config = new MVConfigFile();
				}
				if (!_config.openFile(filename)) {
					main.setStatusBar("Unable to open new format Config file " + filename + ": " + Data.LastError);
					return false;
				}

				main.setStatusBar("Successfully opened new format Config File " + _config.getFilename());
				return true;
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception opening new format Config File: " + e.Message);
				return false;
			}
		}

		internal static bool SaveNewConfigFile(Main main) {
			try {

				if (_config == null) {
					main.setStatusBar("Unable to save new format Config file. No Config File open");
					return false;
				}

				if (!_config.saveFile()) {
					main.setStatusBar("Unable to save new format Config file " + _config.getFilename() + ": " + Data.LastError);
					return false;
				}

				main.setStatusBar("Successfully saved new format Config File " + _config.getFilename());
				return true;
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception saving new format Config File: " + e.Message);
				return false;
			}
		}

		internal static bool SaveNewConfigFileAs(Main main) {
			try {
				if (string.IsNullOrEmpty(_path)) {
					_path = Interaction.InputBox("Enter the path / directory you want to use for saving the new format Config files", "Config File Path", Properties.Settings.Default.DEFAULT_PATH);
					main.setStatusBar("Default path for Config Files set to: " + _path);
					if (!Directory.Exists(_path)) Directory.CreateDirectory(_path);
				}

				string filename = Interaction.InputBox("Enter the name of the (new format) Config file you want to save as", "Save new format Config File As");
				if (string.IsNullOrEmpty(filename)) {
					main.setStatusBar(Data.LastError = "Error: A name is required to save the new format Config File");
					return false;
				}

				if (_config == null) {
					main.setStatusBar("Unable to save new format Config file. No Config File currently open");
					return false;
				}

				filename = _path + Path.DirectorySeparatorChar + Path.ChangeExtension(filename, ConfigData.CONFIG_EXT);
				if (!_config.saveFileAs(filename)) {
					main.setStatusBar("Unable to save new format Config file as " + filename + ": " + Data.LastError);
					return false;
				}

				main.setStatusBar("Successfully saved new format Config File as " + _config.getFilename());
				return true;
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception saving new format Config File: " + e.Message);
				return false;
			}
		}

		internal static bool ViewNewConfigFile(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to view new format Config file. No Config File currently open");
					return false;
				}

				Data.ShowListDataItemsForm(_config.getData());
				main.setStatusBar("Viewing " + _config.getFilename() + " contents");
				return true;
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception viewing new format Config File: " + e.Message);
				return false;
			}
		}

		public static MVConfigFile ConfigFile { get { return _config; } set { _config = value; } }

		private static MVConfigFile _config = null;
		private static string _path = null;
	}
}
