﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using Microsoft.VisualBasic;
using MVShareStore;
using static System.Collections.Specialized.BitVector32;

namespace MVConfigHandler {

	internal class ConfigFiles {

//		private static readonly string DEF_APPNAME = "MVConfig";

		internal static void CreateConfigFile(Main main) {
			try {
				if (string.IsNullOrEmpty(_path)) {
					_path = Interaction.InputBox("Enter the path / directory you want to use for Config files", "Config File Path", Properties.Settings.Default.DEFAULT_PATH);
					main.setStatusBar("Default path for Config Files set to: " + _path);
					if (!Directory.Exists(_path)) Directory.CreateDirectory(_path);
				}

				string filename = Interaction.InputBox("Enter the name of the new Config file you want to create", "Enter New Config File Name");
				if (string.IsNullOrEmpty(filename)) {
					main.setStatusBar(Data.LastError = "A name is required to create a new Config File");
					return;
				}

				filename = _path + Path.DirectorySeparatorChar + Path.ChangeExtension(filename, MVConfigData.CONFIG_EXT);
				if (!File.Exists(filename)) {
					_config = new MVConfigFile();
					_config.newFile(filename);
				}
				else {
					_config = new MVConfigFile(filename);
				}

				if (_config == null) {
					main.setStatusBar("Unable to create new Config file: " + Data.LastError);
				}
				else {
					main.setStatusBar("Successfully created new Config File " + _config.getFilename());
				}
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception creating new Config File: " + e.Message);
			}
		}

		internal static void OpenConfigFile(Main main) {
			try {
				if (string.IsNullOrEmpty(_path)) {
					_path = Interaction.InputBox("Enter the path / directory you want to use for Config files", "Config File Path", Properties.Settings.Default.DEFAULT_PATH);
					main.setStatusBar("Default path for Config Files set to: " + _path);
					if (!Directory.Exists(_path)) Directory.CreateDirectory(_path);
				}

				string filename = Interaction.InputBox("Enter the name of the Config file you want to open or null to select a file", "Open Config File");
				if (string.IsNullOrEmpty(filename)) {
					filename = MVConfigData.SelectFile(_path);
				}
				else {
					filename = _path + Path.DirectorySeparatorChar + Path.ChangeExtension(filename, MVConfigData.CONFIG_EXT);
				}
				if (string.IsNullOrEmpty(filename)) {
					main.setStatusBar(Data.LastError = "Error: A name is required to open a Config File");
					return;
				}

				if (_config == null) {
					_config = new MVConfigFile();
				}
				if (!_config.openFile(filename)) {
					main.setStatusBar("Unable to open the Config file " + filename + ": " + Data.LastError);
				}
				else {
					forms.ListDataItems listDataItems = new forms.ListDataItems(_config);
					listDataItems.Show();
					main.setStatusBar("Successfully opened the Config File " + _config.getFilename());
				}
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception opening Config File: " + e.Message);
			}
		}

		internal static void SaveConfigFile(Main main) {
			try {

				if (_config == null) {
					main.setStatusBar("Unable to save Config file. No Config File open");
					return;
				}

				if (!_config.saveFile()) {
					main.setStatusBar("Unable to save Config file " + _config.getFilename() + ": " + Data.LastError);
				}
				else {
					main.setStatusBar("Successfully saved Config File " + _config.getFilename());
				}
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception saving Config File: " + e.Message);
			}
		}

		internal static void SaveConfigFileAs(Main main) {
			try {
				if (string.IsNullOrEmpty(_path)) {
					_path = Interaction.InputBox("Enter the path / directory you want to use for saving the Config files", "Config File Path", Properties.Settings.Default.DEFAULT_PATH);
					main.setStatusBar("Default path for Config Files set to: " + _path);
					if (!Directory.Exists(_path)) Directory.CreateDirectory(_path);
				}

				string filename = Interaction.InputBox("Enter the name of the Config file you want to save as", "Save Config File As");
				if (string.IsNullOrEmpty(filename)) {
					main.setStatusBar(Data.LastError = "Error: A name is required to save the Config File");
					return;
				}

				if (_config == null) {
					main.setStatusBar("Unable to save Config file. No Config File currently open");
					return;
				}

				filename = _path + Path.DirectorySeparatorChar + Path.ChangeExtension(filename, MVConfigData.CONFIG_EXT);
				if (!_config.saveFileAs(filename)) {
					main.setStatusBar("Unable to save Config file as " + filename + ": " + Data.LastError);
				}
				else {
					main.setStatusBar("Successfully saved Config File as " + _config.getFilename());
				}
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception saving Config File As: " + e.Message);
			}
		}

		internal static void EditConfigFile(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to edit Config file. No Config File currently open");
					return;
				}

				forms.EditDataItems editDataItems = new forms.EditDataItems(_config);
				editDataItems.Show();
//				Data.ShowEditDataItemsForm(_config.getData());
				main.setStatusBar("Editing " + _config.getFilename() + " contents");
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception editing Config File: " + e.Message);
			}
		}

		internal static void AddEntries(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to add new Entries to the Config file. No Config File currently open");
					return;
				}

				forms.AddDataItem addDataItems = new forms.AddDataItem(null);
				if(addDataItems.ShowDialog() == System.Windows.Forms.DialogResult.OK) {
					_config.getData().AddRange(addDataItems.DataItems);
					main.setStatusBar("New Entries successfully added to the current Config File");
				}
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception adding new Entries to Config File: " + e.Message);
			}
		}

		internal static void AddEntry(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to add a new Entry into the Config file. No Config File currently open");
					return;
				}

				string name = Interaction.InputBox("Enter the name of the Entry you want to add to the Config file", "Add Entry to Config File");
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Entry to add to the Config File");
					return;
				}

				string value = Interaction.InputBox("Enter the value of the Entry you want to add to the Config file", "Add Entry to Config File");

				if (!_config.addEntry(name, value)) {
					main.setStatusBar("Unable to add the new Entry to the Config file: " + Data.LastError);
				}
				else {
					main.setStatusBar("Entry " + name + " successfully added to the current Config File");
				}
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception adding Entry to Config File: " + e.Message);
			}
		}

		internal static void AddBoolEntry(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to add a new Boolean Entry into the Config file. No Config File currently open");
					return;
				}

				string name = Interaction.InputBox("Enter the name of the Boolean Entry you want to add to the Config file", "Add Boolean Entry to Config File");
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Entry to add to the Config File");
					return;
				}

				string valueStr = Interaction.InputBox("Enter the Boolean value of the Entry you want to add to the Config file", "Add Boolean Entry to Config File");
				bool value = false;
				if ((valueStr.Equals("1")) || (valueStr.ToUpper().Equals("T")) || (valueStr.ToLower().Equals("true")))
					value = true;

				if (!_config.addEntry(name, value)) {
					main.setStatusBar("Unable to add the new Boolean Entry to the Config file: " + Data.LastError);
				}
				else {
					main.setStatusBar("Boolean Entry " + name + " successfully added to the current Config File");
				}
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception adding Boolean Entry to Config File: " + e.Message);
			}
		}

		internal static void AddIntEntry(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to add a new Integer Entry into the Config file. No Config File currently open");
					return;
				}

				string name = Interaction.InputBox("Enter the name of the Integer Entry you want to add to the Config file", "Add Integer Entry to Config File");
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Integer Entry to add to the Config File");
					return;
				}

				string valueStr = Interaction.InputBox("Enter the Integer value of the Entry you want to add to the Config file", "Add Integer Entry to Config File");
				int value = Convert.ToInt32(valueStr);

				if (!_config.addEntry(name, value)) {
					main.setStatusBar("Unable to add the new Integer Entry to the Config file: " + Data.LastError);
				}
				else {
					main.setStatusBar("Integer Entry " + name + " successfully added to the current Config File");
				}
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception adding Integer Entry to Config File: " + e.Message);
			}
		}

		internal static void AddSection(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to add a new Section to the Config file. No Config File currently open");
					return;
				}

				string section = Interaction.InputBox("Enter the name of the Section you want to add to the Config file", "Add Section to Config File");
				if (string.IsNullOrEmpty(section)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Section to add to the Config File");
					return;
				}

				if(!_config.addSection(section)) {
					main.setStatusBar("Unable to add a new Section to the Config file: " + Data.LastError);
				}
				else { 
					main.setStatusBar("Section " + section + " successfully added to the current Config File");
				}
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception adding Section to Config File: " + e.Message);
			}
		}

		internal static void AddSectionEntry(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to add a new Entry into the specified Section of the Config file. No Config File currently open");
					return;
				}

				string section = Interaction.InputBox("Enter the name of the Section of the Config file you want to add the Entry to", "Add Section Entry to Config File");
				if (string.IsNullOrEmpty(section)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Section to use in the Config File");
					return;
				}

				string name = Interaction.InputBox("Enter the name of the Entry you want to add to that Section in the Config file", "Add Section Entry to Config File");
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Section Entry to add to the Config File");
					return;
				}

				string value = Interaction.InputBox("Enter the value of the Section Entry you want to add to the Config file", "Add Section Entry to Config File");

				if (!_config.addEntry(section, name, value)) {
					main.setStatusBar("Unable to add the new Section Entry to the Config file: " + Data.LastError);
				}
				else {
					main.setStatusBar("Section Entry " + name + " successfully added to Section " + section + " of the current Config File");
				}
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception adding Section Entry to Config File: " + e.Message);
			}
		}

		internal static void AddSecBoolEntry(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to add a new Boolean Entry into the Config file. No Config File currently open");
					return;
				}

				string section = Interaction.InputBox("Enter the name of the Section of the Config file you want to add the Boolean Entry to", "Add Boolean Section Entry to Config File");
				if (string.IsNullOrEmpty(section)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Section to use in the Config File");
					return;
				}

				string name = Interaction.InputBox("Enter the name of the Boolean Entry you want to add to the specified Section of the Config file", "Add Boolean Entry to Config File Section");
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Section Entry to add to the Config File");
					return;
				}

				string valueStr = Interaction.InputBox("Enter the Boolean value of the Entry you want to add to the specified Section of the Config file", "Add Boolean Entry to Config File Section");
				bool value = false;
				if ((valueStr.Equals("1")) || (valueStr.ToUpper().Equals("T")) || (valueStr.ToLower().Equals("true")))
					value = true;

				if (!_config.addEntry(section, name, value)) {
					main.setStatusBar("Unable to add the new Boolean Entry to the specified Section of the Config file: " + Data.LastError);
				}
				else {
					main.setStatusBar("Boolean Entry " + name + " successfully added to Section " + section + " of the current Config File");
				}
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception adding Boolean Entry to the specified Section of the Config File: " + e.Message);
			}
		}

		internal static void AddSecIntEntry(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to add a new Integer Entry into the Config file. No Config File currently open");
					return;
				}

				string section = Interaction.InputBox("Enter the name of the Section of the Config file you want to add the Integer Entry to", "Add Integer Section Entry to Config File");
				if (string.IsNullOrEmpty(section)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Section to use in the Config File");
					return;
				}

				string name = Interaction.InputBox("Enter the name of the Integer Entry you want to add to the specified Section of the Config file", "Add Integer Entry to Config File Section");
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Section Entry to add to the Config File");
					return;
				}

				string valueStr = Interaction.InputBox("Enter the Integer value of the Entry you want to add to the specified Section of the Config file", "Add Integer Entry to Config File Section");
				int value = Convert.ToInt32(valueStr);

				if (!_config.addEntry(section, name, value)) {
					main.setStatusBar("Unable to add the new Integer Entry to the specified Section of the Config file: " + Data.LastError);
				}
				else {
					main.setStatusBar("Integer Entry " + name + " successfully added to Section " + section + " of the current Config File");
				}
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception adding Integer Entry to the specified Section of the Config File: " + e.Message);
			}
		}

		internal static void SetEntry(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to set an Entry in the Config file. No Config File currently open");
					return;
				}

				string name = Interaction.InputBox("Enter the name of the Entry you want to set in or add to the Config file", "Set Entry in Config File");
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Entry to set in the Config File");
					return;
				}

				string value = Interaction.InputBox("Enter the value of the Entry you want to set a value to in the Config file", "Set Entry in Config File");

				_config.setEntry(name, value);            
				main.setStatusBar("Entry " + name + " set in / added to the current Config File");
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception setting Entry in Config File: " + e.Message);
			}
		}

		internal static void SetBoolEntry(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to set a Boolean Entry in the Config file. No Config File currently open");
					return;
				}

				string name = Interaction.InputBox("Enter the name of the Boolean Entry you want to set in or add to the Config file", "Set Boolean Entry in Config File");
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Boolean Entry to set in the Config File");
					return;
				}

				string valueStr = Interaction.InputBox("Enter the Boolean value of the Entry you want to set in the Config file", "Set Boolean Entry in Config File");
				bool value = false;
				if ((valueStr.Equals("1")) || (valueStr.ToUpper().Equals("T")) || (valueStr.ToLower().Equals("true")))
					value = true;

				_config.setEntry(name, value);
				main.setStatusBar("Boolean Entry " + name + " set in / added to the current Config File");
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception setting Boolean Entry in Config File: " + e.Message);
			}
		}

		internal static void SetIntEntry(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to set an Integer Entry in the Config file. No Config File currently open");
					return;
				}

				string name = Interaction.InputBox("Enter the name of the Integer Entry you want to set in or add to the Config file", "Set Integer Entry in Config File");
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Integer Entry to set in the Config File");
					return;
				}

				string valueStr = Interaction.InputBox("Enter the Integer value of the Entry you want to set in the Config file", "Set Integer Entry in Config File");
				int value = Convert.ToInt32(valueStr);

				_config.setEntry(name, value);
				main.setStatusBar("Integer Entry " + name + " set in / added to the current Config File");
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception setting Integer Entry in Config File: " + e.Message);
			}
		}

		internal static void SetSectionEntry(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to set a Section Entry in the Config file. No Config File currently open");
					return;
				}

				string section = Interaction.InputBox("Enter the name of the Section of the Config file you want to set the Entry in", "Set Section Entry in Config File");
				if (string.IsNullOrEmpty(section)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Section to use in the Config File");
					return;
				}

				string name = Interaction.InputBox("Enter the name of the Entry you want to set in or add to the Section in the Config file", "Set Section Entry in Config File");
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Entry to set in the Config File Section");
					return;
				}

				string value = Interaction.InputBox("Enter the value of the Entry you want to set a value to in the Config file", "Set Section Entry in Config File");

				_config.setEntry(section, name, value);
				main.setStatusBar("Entry " + name + " set in / added to Section " + section + " in the current Config File");
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception setting Section Entry in Config File: " + e.Message);
			}
		}

		internal static void SetSecBoolEntry(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to set a Boolean Section Entry in the Config file. No Config File currently open");
					return;
				}

				string section = Interaction.InputBox("Enter the name of the Section of the Config file you want to set the Boolean Entry in", "Set Boolean Section Entry in Config File");
				if (string.IsNullOrEmpty(section)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Section to use in the Config File");
					return;
				}

				string name = Interaction.InputBox("Enter the name of the Boolean Entry you want to set in or add to the Config File Section ", "Set Boolean Section Entry in Config File");
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Boolean Entry to set in the Config File");
					return;
				}

				string valueStr = Interaction.InputBox("Enter the Boolean value of the Section Entry you want to set in the Config file", "Set Boolean Section Entry in Config File");
				bool value = false;
				if ((valueStr.Equals("1")) || (valueStr.ToUpper().Equals("T")) || (valueStr.ToLower().Equals("true")))
					value = true;

				_config.setEntry(section, name, value);
				main.setStatusBar("Boolean Entry " + name + " set in / added to Section " + section + " in the current Config File");
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception setting Boolean Section Entry in Config File: " + e.Message);
			}
		}

		internal static void SetSecIntEntry(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to set an Integer Section Entry in the Config file. No Config File currently open");
					return;
				}

				string section = Interaction.InputBox("Enter the name of the Section of the Config file you want to set the Integer Entry in", "Set Integer Section Entry in Config File");
				if (string.IsNullOrEmpty(section)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Section to use in the Config File");
					return;
				}

				string name = Interaction.InputBox("Enter the name of the Integer Entry you want to set in or add to the Config File Section", "Set Integer Section Entry in Config File");
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Integer Section Entry to set in the Config File");
					return;
				}

				string valueStr = Interaction.InputBox("Enter the Integer value of the Section Entry you want to set in the Config file", "Set Integer Section Entry in Config File");
				int value = Convert.ToInt32(valueStr);

				_config.setEntry(section, name, value);
				main.setStatusBar("Integer Entry " + name + " set in / added to Section " + section + " in the current Config File");
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception setting Integer Section Entry in Config File: " + e.Message);
			}
		}

		internal static void DeleteEntry(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to delete Entries in the Config file. No Config File currently open");
					return;
				}

				string name = Interaction.InputBox("Enter the name of the Entry you want to delete in the Config file", "Delete Entry in Config File");
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Entry to delete in the Config File");
					return;
				}

				if (!_config.delEntry(name)) {
					main.setStatusBar("Unable to delete the Entry " + name + " in the Config file: " + Data.LastError);
				}
				else {
					main.setStatusBar("Entry " + name + " successfully deleted from the current Config File");
				}
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception deleting Entry in Config File: " + e.Message);
			}
		}

		internal static void DeleteSection(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to delete Sections in the Config file. No Config File currently open");
					return;
				}

				string section = Interaction.InputBox("Enter the name of the Section you want to delete in the Config file", "Delete Section in Config File");
				if (string.IsNullOrEmpty(section)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Section to delete in the Config File");
					return;
				}

				if (!_config.delSection(section)) {
					main.setStatusBar("Unable to delete the Section " + section + " in the Config file: " + Data.LastError);
				}
				else {
					main.setStatusBar("Section " + section + " successfully deleted from the current Config File");
				}
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception deleting Section in Config File: " + e.Message);
			}
		}

		internal static void DeleteSecEntry(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to delete Section Entries in the Config file. No Config File currently open");
					return;
				}

				string section = Interaction.InputBox("Enter the name of the Section of the Config file you want to delete the Entry in", "Delete Section Entry in Config File");
				if (string.IsNullOrEmpty(section)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Section to delete from in the Config File");
					return;
				}

				string name = Interaction.InputBox("Enter the name of the Section Entry you want to delete in the Config file", "Delete Section Entry in Config File");
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Section Entry to delete in the Config File");
					return;
				}

				if (!_config.delEntry(section, name)) {
					main.setStatusBar("Unable to delete the Entry " + name + " from Section " + section + " in the Config file: " + Data.LastError);
				}
				else {
					main.setStatusBar("Entry " + name + " successfully deleted from section " + section + " in the current Config File");
				}
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception deleting Section Entry in Config File: " + e.Message);
			}
		}

		internal static void ClearEntries(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to clear the Entries in the Config file. No Config File currently open");
					return;
				}

				int count = _config.clearEntries();
				main.setStatusBar(count + " Global Entries cleared from the current Config File");
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception clearing global Entries in Config File: " + e.Message);
			}
		}

		internal static void ClearSections(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to clear the Sections in the Config file. No Config File currently open");
					return;
				}

				int count = _config.clearSections();
				main.setStatusBar(count + " Sections cleared from the current Config File");
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception clearing Sections in Config File: " + e.Message);
			}
		}

		internal static void ClearAll(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to clear all the Sections and Entries in the Config file. No Config File currently open");
					return;
				}

				int count = _config.clearAll();
				main.setStatusBar(count + " Sections and Entries cleared from the current Config File");
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception clearing sections and Entries in Config File: " + e.Message);
			}
		}

		internal static void ViewConfigFile(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to view Config file. No Config File currently open");
					return;
				}

				forms.ListDataItems listDataItems = new forms.ListDataItems(_config);
				listDataItems.Show();
//				Data.ShowListDataItemsForm(_config.getData());
				main.setStatusBar("Viewing " + _config.getFilename() + " contents");
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception viewing Config File: " + e.Message);
			}
		}

		internal static void ViewEntry(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to view Entry in the Config file. No Config File currently open");
					return;
				}

				string name = Interaction.InputBox("Enter the name of the Entry you want to view", "View Entry in Config File");
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Entry in the Config File you want to view");
					return;
				}

				ViewConfigEntry(main, _config.getEntry(name));
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception viewing Config File Entry: " + e.Message);
			}
		}

		internal static void ViewSectionEntry(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to view Section Entry in the Config file. No Config File currently open");
					return;
				}

				string section = Interaction.InputBox("Enter the name of the Section containing the Entry you want to view", "View Section Entry in Config File");
				if (string.IsNullOrEmpty(section)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Section to find the Entry in");
					return;
				}

				string name = Interaction.InputBox("Enter the name of the Section Entry you want to view", "View Section Entry in Config File");
				if (string.IsNullOrEmpty(name)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Section Entry in the Config File you want to view");
					return;
				}

				ViewConfigSectionEntry(main, section, _config.getEntry(section, name));
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception viewing Config File Section Entry: " + e.Message);
			}
		}

		internal static void ListSectionNames(Main main) {
			string list = "Section Names:";
			List<string> names = new List<string>(_config.getSectionNames());
			if ((names == null) || (names.Count == 0)) {
				main.setStatusBar(Data.LastError = "No Sections found in this Config File");
				return;
			}

			foreach (string name in names) {
				list += "\n" + name;
			}
			MessageBox.Show(list, "Section Names");
		}

		internal static void ListSectionEntries(Main main) {
			try { 
				string section = Interaction.InputBox("Enter the name of the Section containing the Entries you want to view", "View Section Entries in Config File");
				if (string.IsNullOrEmpty(section)) {
					main.setStatusBar(Data.LastError = "Error: A name is required for the Section to find the Entries in");
					return;
				}

				MVConfigFile file = new MVConfigFile();
				MVConfigEntry[] entries = new MVConfigEntry[_config.getCount()];
				entries = _config.getSectionEntries(section);
				if ((entries == null) || (entries.Length == 0)) {
					main.setStatusBar(Data.LastError = "Section name " + section + " is not valid or no entries found in that Section");
					return;
				}

				foreach (MVConfigEntry entry in entries) {
					if(entry != null) file.addEntry(entry.Name, entry.Value);
				}

				forms.ListDataItems listDataItems = new forms.ListDataItems(file);
				listDataItems.Show();
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception viewing Config File Section Entries: " + e.Message);
			}
		}

		internal static MVConfigFile ConfigFile { get { return _config; } set { _config = value; } }

		private static void ViewConfigEntry (Main main, MVConfigEntry entry) {
			string msg = null;
			if(entry == null) {
				msg = "Config Entry is null";
			}
			else if(entry.Type == MVConfigEntry.EntryType.BOOL) {
				msg = "Config Boolean Entry " + entry.Name + ". Value = " + entry.BoolValue;
			}
			else if (entry.Type == MVConfigEntry.EntryType.INT) {
				msg = "Config Integer Entry " + entry.Name + ". Value = " + entry.IntValue;
			}
			else {
				msg = "Config Entry " + entry.Name + ". Value = " + entry.Value;
			}
			MessageBox.Show(main.setStatusBar(msg), "View Config File Entry");
		}

		private static void ViewConfigSectionEntry(Main main, string section, MVConfigEntry entry) {
			string msg = null;
			if (entry == null) {
				msg = "Config Section Entry is null";
			}
			else if (entry.Type == MVConfigEntry.EntryType.BOOL) {
				msg = "Config Section " + section + ": Boolean Entry " + entry.Name + ". Value = " + entry.BoolValue;
			}
			else if (entry.Type == MVConfigEntry.EntryType.INT) {
				msg = "Config Section " + section + ": Integer Entry " + entry.Name + ". Value = " + entry.IntValue;
			}
			else {
				msg = "Config Section " + section + ": Entry " + entry.Name + ". Value = " + entry.Value;
			}
			MessageBox.Show(main.setStatusBar(msg), "View Section Config File Entry");
		}

		internal static void ViewListAllEntries(Main main) {
			try {
				if (_config == null) {
					main.setStatusBar("Unable to list all the Entries in the Config file. No Config File currently open");
					return;
				}

				forms.ListDataItems listDataItems = new forms.ListDataItems(_config, true);
				listDataItems.Show();
				main.setStatusBar("Viewing all Entries in " + _config.getFilename());
			}
			catch (Exception e) {
				main.setStatusBar(Data.LastError = "Exception viewing all Entries in the Config File: " + e.Message);
			}
		}

		private static MVConfigFile _config = null;
		private static string _path = null;

	}
}
