﻿using System;
using System.IO;
using System.Text;
using System.Windows.Forms;
using System.Collections.Generic;
using MVConfig;

namespace MVConfigHandler.forms
{
	public partial class ViewOldConfigFile : Form
	{
//		private static readonly string TAB = "\t";
//		private static readonly string SPACES = "   ";

		internal ViewOldConfigFile(MVConfigFile file) {
			InitializeComponent();

			_file = file;
		}

		private void ViewFile_Load(object sender, EventArgs e) {
//			int pos = 0, index = 0; bool first = true;

			try {

				this.Text = "File: " + _file.getFilename();
				StatusStrip.Items[0].Text = "Viewing File: " + _file.getFilename() + ". Press Esc to Exit";
			}
			catch (Exception ex) {
				MessageBox.Show("Sorry, there is a problem showing the file: " + ex.Message, "MV Config View File", MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
		}

		private void ListView_Resize(object sender, EventArgs e) {
			ListView.Columns[1].Width = ListView.Width - 78;
		}

		private void CopyStripMenuItem_Click(object sender, EventArgs e) {
			ListView.SelectedListViewItemCollection items = ListView.SelectedItems;
			if ((items == null) || (items.Count == 0)) return;
			StringBuilder lines = new StringBuilder();
			foreach (ListViewItem item in items) {
				lines.AppendLine(item.SubItems[1].Text);
			}
			Clipboard.SetData(DataFormats.Text, lines.ToString());
		}

		private void CloseBtn_Click(object sender, EventArgs e) {
			this.Close();
		}

		private MVConfigFile _file;
	}
}
