﻿using MVShareStore;
using System;
using System.Reflection;
using System.Windows.Forms;
//using static MVShareStore.MVConfigFile;

namespace MVConfigHandler.forms
{
	/// <summary>
	/// List the Data Items in the supplied DataPack / DataShare or DataStore (basically a read only version of the EditDataItems form).
	/// </summary>
	public partial class ListDataItems : Form
	{
		/// <summary>
		/// List the Data Items in the supplied DataPack / DataShare or DataStore (basically a read only version of the EditDataItems form).
		/// </summary>
		/// <param name="config">The Config File to be listed</param>
		/// <param name="listAll">List all the Global and Section Entries</param>
		public ListDataItems(MVConfigFile config, bool listAll = false) {
			InitializeComponent();

			if (config == null) config = new MVConfigFile();
			ConfigFile = config;
			RefreshList(config, listAll);
			StatusBar.Items[0].Text = this.Text = "List the Data Items in the Config File";
		}

		/// <summary>
		/// The Data Pack to list the Data Items in
		/// </summary>
		public MVConfigFile ConfigFile { get; private set; } = null;

		private void ListView_Resize(object sender, EventArgs e) {
			ListView.Columns[3].Width = ListView.Width - (ListView.Columns[0].Width + ListView.Columns[1].Width + ListView.Columns[2].Width + 5);
		}

		private void SelectedIndex_Changed(object sender, EventArgs e) {
			if ((ListView.Items.Count > 0) && (ListView.SelectedItems.Count > 0)) {
				_currentItem = ListView.SelectedItems[0];
				_currentIndex = ListView.SelectedIndices[0];
			}
			else
				_currentIndex = -1;
		}

		private void ListView_KeyDown(object sender, KeyEventArgs e) {
			if (e.KeyCode == Keys.Enter) ViewItem();
			if (e.KeyCode == Keys.Escape) CancelBtn_Click(sender, e);
		}

		private void ListView_MouseDoubleClick(object sender, MouseEventArgs e) {
			ViewItem();
		}

		private void CancelBtn_Click(object sender, EventArgs e) {
//			if (ConfigFile != null) { ConfigFile.close(); }
			Close();
		}

		private void CloseBtn_Click(object sender, EventArgs e) {
//			if (ConfigFile != null) { ConfigFile.close(); }
			Close();
		}

		private void RefreshList(MVConfigFile config, bool listAll = false) {
			if(config == null) return;

			int index = 0;
			MVConfigEntry entry = null;
			ListView.Items.Clear();

			try {
				//	The foreach loop is a far better way of doing this but it is done this way simply to test these functions
				if (!listAll) {
					if (config.findFirst(out entry)) {
						setDataItem(MVConfigEntry.toDataItem(entry), index++);
						while (config.findNext(out entry)) {
							setDataItem(MVConfigEntry.toDataItem(entry), index++);
						}
					}
					string section = config.findFirstSection();
					while (!string.IsNullOrEmpty(section)) {
						setDataItem(config.getData().GetItem(section), index++);
						section = config.findNextSection();
					}
				}
				else {
					if ((entry = config.getFirst()) != null) {
						setDataItem(MVConfigEntry.toDataItem(entry), index++);
						while ((entry = config.getNext()) != null) {
							setDataItem(MVConfigEntry.toDataItem(entry), index++);
						}
					}
				}
			}
			catch (Exception ex) {
				MessageBox.Show("Exception Refreshing the Entries List: " + ex, "List Config Entries");
			}
/*
			foreach(DataItem item in ConfigFile.getData()) {
				if(item != null) setDataItem(item, index++);
			}
*/
/*
			DataItem item = dataPack.getFirst();
			if(item != null) setDataItem(item, index++);
			while (dataPack.hasNext()) {
				item = dataPack.getNext();
				setDataItem(item, index++);
			}
*/
		}

		private void ViewItem() {
			if((_currentItem == null) || (_currentIndex == -1)) return;
			MVConfigData data = ConfigFile.getData();
			if ((data.GetItem(_currentItem.SubItems[2].Text).Type) != MVShareStore.DataType.TYPE.DATAPACK) return;
			MVConfigFile config = new MVConfigFile(data.GetItem(_currentItem.SubItems[2].Text).DatapackValue);
			ListDataItems listDataItems = new ListDataItems(config);
			listDataItems.Show();
		}

		private void setDataItem(DataItem item, int index) {
			ListViewItem listItem = new ListViewItem(index.ToString());
			listItem.SubItems.Add(item.Desc);
			listItem.SubItems.Add(item.Name);
			listItem.SubItems.Add(item.AsStringValue);
			ListView.Items.Add(listItem);
		}

		private string setStatusBar(string status) {
			StatusBar.Items[0].Text = status;
			return status;
		}

//		private Font _headerFont = null;
		private ListViewItem _currentItem = null;
		private int _currentIndex = -1;
	}
}

/*
 * 			if(dataPack.ItemCount > 0) {
				foreach(DataItem item in dataPack.Items) {
					ListViewItem listItem = new ListViewItem(index.ToString());
					listItem.SubItems.Add(item.Desc);
					listItem.SubItems.Add(item.Name);
					listItem.SubItems.Add(item.StringValue);
					ListView.Items.Add(listItem);
					index++;
				}
*/