﻿using System;
using System.Windows.Forms;

namespace MVConfigHandler
{
	public partial class Main : Form
	{
		public Main() {
			InitializeComponent();
		}

		internal string setStatusBar(string status) {
			return StatusBar.Items[0].Text = status;
		}

		private void FileNewConfigMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.CreateConfigFile(this);
		}

		private void FileOpenConfigMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.OpenConfigFile(this);
		}

		private void FileSaveConfigMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.SaveConfigFile(this);
		}

		private void FileSaveConfigAsMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.SaveConfigFileAs(this);
		}

		private void FileExitMenuItem_Click(object sender, EventArgs e) {
			Close();
		}

		private void EditMenu_DropDownOpening(object sender, EventArgs e) {
			EditConfigFileMenuItem.Enabled = EditAddEntryMenuItem.Enabled = EditAddEntriesMenuItem.Enabled = EditAddSectionMenuItem.Enabled = EditAddSecEntryMenuItem.Enabled = EditDeleteEntryMenuItem.Enabled = EditDeleteSectionMenuItem.Enabled = EditDeleteSecEntryMenuItem.Enabled = EditClearEntriesMenuItem.Enabled = EditClearSectionsMenuItem.Enabled = EditClearAllMenuItem.Enabled = EditSetEntryMenuItem.Enabled = EditSetBoolEntryMenuItem.Enabled = EditSetIntEntryMenuItem.Enabled = EditSetSecEntryMenuItem.Enabled = EditSetSecBoolEntryMenuItem.Enabled = EditSetSecIntEntryMenuItem.Enabled = false;
			if (ConfigFiles.ConfigFile != null)
				EditConfigFileMenuItem.Enabled = EditAddEntryMenuItem.Enabled = EditAddEntriesMenuItem.Enabled = EditAddSectionMenuItem.Enabled = EditAddSecEntryMenuItem.Enabled = EditDeleteEntryMenuItem.Enabled = EditDeleteSectionMenuItem.Enabled = EditDeleteSecEntryMenuItem.Enabled = EditClearEntriesMenuItem.Enabled = EditClearSectionsMenuItem.Enabled = EditClearAllMenuItem.Enabled = EditSetEntryMenuItem.Enabled = EditSetBoolEntryMenuItem.Enabled = EditSetIntEntryMenuItem.Enabled = EditSetSecEntryMenuItem.Enabled = EditSetSecBoolEntryMenuItem.Enabled = EditSetSecIntEntryMenuItem.Enabled = true;
		}

		private void EditConfigFileMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.EditConfigFile(this);
		}

		private void EditAddEntriesMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.AddEntries(this);
		}

		private void EditAddEntryMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.AddEntry(this);
		}

		private void EditAddBoolEntryMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.AddBoolEntry(this);
		}

		private void EditAddIntEntryMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.AddIntEntry(this);
		}

		private void EditAddSectionMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.AddSection(this);
		}

		private void EditAddSecEntryMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.AddSectionEntry(this);
		}

		private void EditAddBoolSecEntryMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.AddSecBoolEntry(this);
		}

		private void EditAddIntSecEntryMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.AddSecIntEntry(this);
		}

		private void EditSetEntryMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.SetEntry(this);
		}

		private void EditSetBoolEntryMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.SetBoolEntry(this);
		}

		private void EditSetIntEntryMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.SetIntEntry(this);
		}

		private void EditSetSecEntryMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.SetSectionEntry(this);
		}

		private void EditSetSecBoolEntryMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.SetSecBoolEntry(this);
		}

		private void EditSetSecIntEntryMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.SetSecIntEntry(this);
		}

		private void EditDeleteEntryMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.DeleteEntry(this);
		}

		private void EditDeleteSectionMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.DeleteSection(this);
		}

		private void EditDeleteSecEntryMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.DeleteSecEntry(this);
		}

		private void EditClearEntriesMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.ClearEntries(this);
		}

		private void EditClearSectionsMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.ClearSections(this);
		}

		private void EditClearAllMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.ClearAll(this);
		}

		private void ViewMenu_DropDownOpening(object sender, EventArgs e) {
			ViewConfigFileMenuItem.Enabled = ViewEntryMenuItem.Enabled = ViewSectionEntryMenuItem.Enabled = ViewListSectionNamesMenuItem.Enabled = ViewListSectionEntriesMenuItem.Enabled = ViewListAllEntriesMenuItem.Enabled = false;
			if (ConfigFiles.ConfigFile != null)
				ViewConfigFileMenuItem.Enabled = ViewEntryMenuItem.Enabled = ViewSectionEntryMenuItem.Enabled = ViewListSectionNamesMenuItem.Enabled = ViewListSectionEntriesMenuItem.Enabled = ViewListAllEntriesMenuItem.Enabled = true;
		}

		private void ViewConfigFileMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.ViewConfigFile(this);
		}

		private void ViewEntryMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.ViewEntry(this);
		}

		private void ViewSectionEntryMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.ViewSectionEntry(this);
		}

		private void ViewListSectionNamesMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.ListSectionNames(this);
		}

		private void ViewListSectionEntriesMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.ListSectionEntries(this);
		}

		private void ViewListAllEntriesMenuItem_Click(object sender, EventArgs e) {
			ConfigFiles.ViewListAllEntries(this);
		}
	}
}
